TITLE 							                  { exa85a.pde }
   'Conduction in a Plate with an Elliptical Insert'
SELECT
   errlim=3e-4     ngrid=1     spectral_colors
VARIABLES
   U
DEFINITIONS
   Lx=1     Ly=1     cond=5.99e7				{ Conductivity }
   Ex=-dx(U)     Ey=-dy(U)     E=-grad(U)     Em=magnitude(E)
   Jx=cond*Ex     Jy=cond*Ey     J=cond*E     Jm=magnitude(J)
   J_angle=sign( Jy)*arccos( Jx/Jm)/pi*180
EQUATIONS
   div( J)=0
BOUNDARIES
region 'domain'        			               		{ Copper }
   start 'boundary' (0,-Ly)   value( U)=0 line to (Lx,-Ly)  to (Lx,0)
   natural(U)=0   line to (Lx,Ly)   to  (0,Ly)		{ Insulated }
   value(U)=1.0  line to (-Lx,Ly)   to (-Lx,0)
   natural (U)=0  line to (-Lx,-Ly)  close      		{ Insulated }
region 'iron' cond=1.03e7    				
   start(Lx/5,0)
   arc( center=0,0) to (0, Ly/2) to (-Lx/5,0) to (0,-Ly/2)  close
PLOTS
   vector( J) norm    contour( J_angle)    contour( J_angle) on 'iron'
END


